from codeableModels import *
from metamodels.microserviceComponentsMetamodel import *

cart = CClass(component, 'Cart', stereotypeInstances = [service])
catalogue = CClass(component, 'Catalogue', stereotypeInstances = [service])
dispatch = CClass(component, 'Dispatch', stereotypeInstances = [service])
payment = CClass(component, 'Payment', stereotypeInstances = [service])
ratings = CClass(component, 'Ratings', stereotypeInstances = [service])
shipping = CClass(component, 'Shipping', stereotypeInstances = [service])
user = CClass(component, 'User', stereotypeInstances = [service])
NGINXAPIGateway = CClass(component, 'NGINX API Gateway', stereotypeInstances = [service, facade])
addLinks({NGINXAPIGateway: catalogue}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: user}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: cart}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: shipping}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: payment}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({NGINXAPIGateway: ratings}, roleName = "target", stereotypeInstances = [restfulHTTP])
RESTAPIClient = CClass(component, 'REST API Client', stereotypeInstances = [client])
addLinks({RESTAPIClient: NGINXAPIGateway}, roleName = "target", stereotypeInstances = [restfulHTTP])
webUIClient = CClass(component, 'Web UI Client', stereotypeInstances = [webUI])
addLinks({webUIClient: NGINXAPIGateway}, roleName = "target", stereotypeInstances = [http])
addLinks({cart: catalogue}, roleName = "target", stereotypeInstances = [restfulHTTP, asynchronousConnector])
cartandAnonymousUserCountDB = CClass(component, 'Cart and Anonymous User Count DB', stereotypeInstances = [redisDB])
addLinks({cart: cartandAnonymousUserCountDB}, roleName = "target", stereotypeInstances = [resp, syncAsyncConnector])
addLinks({user: cartandAnonymousUserCountDB}, roleName = "target", stereotypeInstances = [resp, synchronousConnector])
cartPrometheusMonitor = CClass(component, 'Cart Prometheus Monitor', stereotypeInstances = [monitoringComponent])
addLinks({cart: cartPrometheusMonitor}, roleName = "target", stereotypeInstances = [inMemoryConnector])
catalogueUsersOrdersDB = CClass(component, 'Catalogue Users Orders DB', stereotypeInstances = [mongoDB])
addLinks({catalogue: catalogueUsersOrdersDB}, roleName = "target", stereotypeInstances = [mongoWire])
addLinks({user: catalogueUsersOrdersDB}, roleName = "target", stereotypeInstances = [mongoWire])
paypalPaymentGateway = CClass(component, 'Paypal Payment Gateway', stereotypeInstances = [service, externalComponent])
addLinks({payment: paypalPaymentGateway}, roleName = "target", stereotypeInstances = [restfulHTTP, synchronousConnector])
addLinks({payment: user}, roleName = "target", stereotypeInstances = [restfulHTTP, synchronousConnector])
addLinks({payment: cart}, roleName = "target", stereotypeInstances = [restfulHTTP, synchronousConnector])
paymentPrometheusMonitor = CClass(component, 'Payment Prometheus Monitor', stereotypeInstances = [monitoringComponent])
addLinks({payment: paymentPrometheusMonitor}, roleName = "target", stereotypeInstances = [inMemoryConnector])
instanaAgent = CClass(component, 'Instana Agent', stereotypeInstances = [tracingComponent, externalComponent])
addLinks({cart: instanaAgent}, roleName = "target", stereotypeInstances = [http2])
addLinks({catalogue: instanaAgent}, roleName = "target", stereotypeInstances = [http2])
addLinks({dispatch: instanaAgent}, roleName = "target", stereotypeInstances = [http2])
addLinks({payment: instanaAgent}, roleName = "target", stereotypeInstances = [http2])
addLinks({user: instanaAgent}, roleName = "target", stereotypeInstances = [http2])
rabbitMQ = CClass(component, 'Rabbit MQ', stereotypeInstances = [messageBroker])
addLinks({payment: rabbitMQ}, roleName = "target", stereotypeInstances = [messageProducer], taggedValues = {'channel' : 'orders'})
addLinks({dispatch: rabbitMQ}, roleName = "target", stereotypeInstances = [messageConsumer], taggedValues = {'channel' : 'orders'})
ratingsandShippingCitiesDB = CClass(component, 'Ratings and Shipping Cities DB', stereotypeInstances = [mySQLDB])
addLinks({ratings: ratingsandShippingCitiesDB}, roleName = "target", stereotypeInstances = [mySQLProtocol])
addLinks({ratings: catalogue}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({shipping: cart}, roleName = "target", stereotypeInstances = [restfulHTTP])
addLinks({shipping: ratingsandShippingCitiesDB}, roleName = "target", stereotypeInstances = [jdbc])


model = CBundle("model", elements = [cart, catalogue, dispatch, payment, ratings, shipping, user, NGINXAPIGateway, RESTAPIClient, webUIClient, cartandAnonymousUserCountDB, cartPrometheusMonitor, catalogueUsersOrdersDB, paypalPaymentGateway, paymentPrometheusMonitor, instanaAgent, rabbitMQ, ratingsandShippingCitiesDB])
modelViews = [model, {}]
